Attribute VB_Name = "Module1"

'**********************************************************
' Author:  Mahatab-ur-Rashid
' E-mail:  mahatabur@yahoo.com
' WebSite: http://www.mahatabs.allhere.com
' MyClub:  http://www.clubs.yahoo.com/clubs/atozprogramming
'**********************************************************


'*** Declaring required APIs ***
'=========================================================

'The following API (DrawIcon) can displays an icon on a
'device.

'PARAMETERS:
' hdc:
'       A handle to a device context to the device to draw
'       the icon on
' X  :
'       The x-coordinate of the point to position the
'       upper-left corner of the icon's image at
' Y  :
'       The y-coordinate of the point to position the
'       upper-left corner of the icon's image at
'hIcon:
'       A handle to the icon to display

'=========================================================

Public Declare Function DrawIcon Lib "user32.dll" ( _
                ByVal hdc As Long, ByVal x As Long, _
                ByVal y As Long, ByVal hIcon As Long) _
                As Long

'=========================================================

'The following API (DestroyIcon) destroys an _
'icon and frees the memory which contained the icon

'PARAMETERS:
' hIcon:
'        A handle to the icon to destroy.

'=========================================================

Public Declare Function DestroyIcon Lib "user32.dll" ( _
                ByVal hIcon As Long) As Long


'=========================================================

'The following API (ExtractIcon) extracts a single icon from
'a file. This file can be an executable (.exe) file, a
'dynamic link library (.dll), or an icon file (.ico).
'Alternately, this function can also determine how many icons
'are stored in such a file. The icon generated by this
'function must be destroyed using DestroyIcon after the
'program has finished using it.

'PARAMETERS:

'hInst:
'         A handle to the instance of the application calling
'         the function.
'lpszExeFileName:
'         The name of an .exe, .dll, or .ico to
'         extract an icon from.
'nIconIndex:
'         If this is -1, the function returns the number
'         of icons stored in the specified file. If this
'         is a non-negative number, the function extracts
'         the icon using this value as the zero-based
'         index.

'=========================================================

Public Declare Function ExtractIcon Lib "shell32.dll" _
                Alias "ExtractIconA" (ByVal hInst As Long, _
                ByVal lpszExeFileName As String, _
                ByVal nIconIndex As Long) As Long



'=========================================================
'The following API (keybd_event) simulates keyboard input
'by placing a keyboard input event into the input stream.
'The function can simulate a single press or release of a
'single key

'PARAMETERS:

'bVk:
'      The virtual-key code(Like "VK_LBUTTON" as The left mouse button
'      or VK_RBUTTON as The right mouse button etc) of the key to simulate
'      pressing or releasing.
'bScan:
'      Reserved -- set to 0.
'dwFlags:
'      A combination of the following flags specifying what kind of
'      keyboard input to synthesize: KEYEVENTF_EXTENDEDKEY
'      Prefix the scan code with a prefix byte having the
'      value &HE0. KEYEVENTF_KEYUP The key specified in bVk is being
'      released. If this flag is not specified, the key is being pressed.
'dwExtraInfo:
'      An additional 32-bit value associated with the keyboard event.

'=======================================================================


Public Declare Sub keybd_event Lib "user32" ( _
                   ByVal bVk As Byte, ByVal bScan As Byte, _
                   ByVal dwFlags As Long, ByVal dwExtraInfo _
                   As Long)



Public Const KEYEVENTF_KEYUP = &H2 'Constant value for keyup
Public Const VK_SNAPSHOT = &H2C    'Constant value for PrintScreen key
Public Const VK_MENU = &H12        'Constant value for ALT key


Public I As Integer  'Mainly maintain pictureboxes index number
Public j As Integer  'Mainly maintain Icon's index in file

Public NumberOfIcon As Integer ' Stores total number of icons
Public fileName As String      ' Stores File1.Filename value.
                            '*(File1 = FileListBox Control)

Public IconNumber As Integer 'This will use to get a snap shot of a icon

'========================================================

'The following FUNCTION can extract a icon from a file and
'and draw on the control which "hDc" value is provided

'hDc:
'Returns a handle provided by the Microsoft Windows
'operating environment to the device context of an object

'PARAMETERS:
'
'fileNameWithPath:
'       The file Name(With full path)which we are going to
'        extract
'iconNumber:
'       Icon's index number
'Ctrl:
'       Name of the control where we want to draw icon

'Return Value:
'       Function will return 1 if operation unsuccessfull
'       else return 0
'
'       If we pass iconNumber as -1 as parameters then the
'       function returns TOTAL NUMBER OF ICONS IN THE FILE

'==========================================================

Public Function ExtractIconAndShow(ByVal Path As String, ByVal fileName As String, IconNumber As Integer, _
                                   ByVal Modo As String, ByRef fHayMas As Boolean, ByRef nTotal As Integer, _
                                   nSiguiente As Integer)

    Dim hIcon As Long  ' handle to the function gotten from the executable file
    Dim retval As Long ' return value
    Dim k As Long
    Dim j As Integer
    Dim Anterior As Integer
    
    If Right$(Path, 1) <> "\" Then
        Path = Path & "\"
    End If
    
    fileName = Path & fileName
    
    If nTotal = 0 Then
        hIcon = ExtractIcon(frmMain.hWnd, fileName, IconNumber)
        nTotal = hIcon
    Else
        hIcon = nTotal
    End If
    
    If hIcon <> 0 Then
        frmMain.Prog1.Min = 0
        frmMain.Prog1.Value = 0
        frmMain.Prog1.Max = nTotal
        frmMain.Prog1.Visible = True
        
        fHayMas = False
        j = 0
        
        If Modo = "A" Then
            For k = nSiguiente To hIcon
                   
                If j > 47 Then
                    fHayMas = True
                    nSiguiente = k
                    Exit For
                End If
                
                hIcon = ExtractIcon(frmMain.hWnd, fileName, k)
                
                retval = DrawIcon(frmMain.Pic1(j).hdc, 0, 0, hIcon)
                
                frmMain.Prog1.Value = k
    
                retval = DestroyIcon(hIcon)
                
                frmMain.Pic1(j).AutoRedraw = True
                frmMain.Pic1(j).Refresh
                
                DoEvents
                
                j = j + 1
            Next k
        Else
            Anterior = nSiguiente - 47 - 1
            If Anterior < 0 Then
                Anterior = 0
                nSiguiente = 48
            End If
            j = 0
            
            For k = Anterior - 47 - 1 To Anterior - 1
                
                hIcon = ExtractIcon(frmMain.hWnd, fileName, k)
                
                retval = DrawIcon(frmMain.Pic1(j).hdc, 0, 0, hIcon)
                
                frmMain.Prog1.Value = k
    
                retval = DestroyIcon(hIcon)
                
                frmMain.Pic1(j).AutoRedraw = True
                frmMain.Pic1(j).Refresh
                
                DoEvents
                
                j = j + 1
            Next k
            
            If j < nTotal Then
                fHayMas = True
                nSiguiente = k
            End If
        End If
        
        If fHayMas Then
            frmMain.StatusBar1.SimpleText = "Icons loaded " & nSiguiente & " of : " & nTotal & " Icon(s) in " & fileName
        Else
            frmMain.StatusBar1.SimpleText = "Icons loaded " & nTotal & " of : " & nTotal & " Icon(s) in " & fileName
        End If
    Else
        frmMain.StatusBar1.SimpleText = "No icons in file"
    End If
    
    frmMain.Prog1.Min = 0
    frmMain.Prog1.Value = 0
    frmMain.Prog1.Max = 1
    frmMain.Prog1.Visible = False
    frmMain.PicSelec.Picture = Nothing
    
End Function

Public Sub Main()
    frmMain.Show
End Sub


